uniform sampler2D 			bg,
							bmp,
							tex,
							depthBG;
uniform samplerCube			ambientCube;
uniform samplerCube			ambientCubeDiffuse;
uniform sampler2D			brdfLUT;
uniform sampler2D 			bmp1;
uniform sampler2D 			bmp2;
uniform sampler2DShadow 	shadowmap;
uniform sampler2DShadow 	shadowmap2;
uniform sampler2DShadow 	shadowmap4;
uniform sampler2DShadow 	shadowmapGlobal;

varying vec2 		texcoord;
varying vec2 		texcoord1;
varying vec2 		texcoord3;

varying vec4 		pos;
varying vec4		eyepos;
uniform vec2		density;
uniform vec3		refrColor;
uniform vec3		diffuseColor;
uniform vec3		ambientColor;
uniform float		transparency;

varying float slope;

uniform float cubeLod;
uniform float cubeLod2;

uniform float invAmbientRange;
uniform vec3 ambientPos;
uniform float ambientScatter;

uniform float foamW;

//uniform float 		reflMul;
uniform float		alphalevel;
varying vec2 		texcoord2;

// SHADOWMAP PARAMS
uniform float 		lightrange;
uniform float 		lightrange2;
uniform float 		lightrange4;
uniform float 		lightrange8;
	
uniform int 		split4;
uniform int 		split8;

uniform float		cOfs;

uniform vec4		LTM0,
					LTM1,
					LTM2,
					LTM3;

uniform vec4		LTM0b,
					LTM1b,
					LTM2b,
					LTM3b;
					
uniform vec4		LTM0c,
					LTM1c,
					LTM2c,
					LTM3c;
			
uniform vec4		LTM0e,
					LTM1e,
					LTM2e,
					LTM3e;	
					
uniform mat4		reprojTM2;
uniform mat4		reprojTM4;
//uniform mat4		reprojTM8;

//////////////////////////////////////////

uniform vec3		lightDir;
//uniform float		lightscale;
uniform vec4		lightcolor;

uniform vec4 		reflColorMul;

uniform samplerCube	reflCube;
uniform float		reflScale;
uniform float		reflPow;

varying mat3		TBN;
varying vec3		viewDir;

uniform vec2 		spec;
uniform vec2		fresnel;
varying vec4 		vpos;


///////// LIGHTS ////////////////////////
uniform float 		light0;
uniform vec3 		lightpos0;
uniform vec3 		lightdir0;
uniform float 		lightCos0;
uniform vec3 		lightColor0;
uniform float 		lightRange0;
uniform float 		lightfallof0;

uniform float 		light1;
uniform vec3 		lightpos1;
uniform vec3 		lightdir1;
uniform float 		lightCos1;
uniform vec3 		lightColor1;
uniform float 		lightRange1;
uniform float 		lightfallof1;
///////////////////////////////////////////

// TAO /////////
//varying float TAO;

//varying vec4		fog;
varying vec3 		Fex;
varying vec3 		Lin;
float				Pi=3.14159265359;

vec4 refl=vec4(0.0,0.0,0.0,0.0);
float reflInt=0.0;
vec3 litColor=vec3(0.0,0.0,0.0);
vec3 diffuse=vec3(0.0,0.0,0.0);
vec4 texColor;
vec4 texColor1;
vec4 texColor2;
float shadowOcc;
float lightDist;
	
vec4 normalColor;

// ------------ ATMOSPHERE ------------------------------
uniform float 		length_unit;
uniform vec3 		earth_center;
uniform vec3 		sundirW;

vec3 GetSunIrradiance(vec3 p, vec3 sun_direction);
// ------------------------------------------------
	
vec4 RGBMDecode( vec4 rgbm ) {
  return vec4(6.0 * rgbm.rgb * rgbm.a,1.0);
}

vec3 cubeLookup(vec3 v, float lod) {
   float M = max(max(abs(v.x), abs(v.y)), abs(v.z));
   float scale = 1.0 - exp2(lod) / 128.0;
   if (abs(v.x) != M) v.x *= scale;
   if (abs(v.y) != M) v.y *= scale;
   if (abs(v.z) != M) v.z *= scale;
   return v;
}

float phong_diffuse()
{
	return (1.0 / Pi);
}

vec3 fresnel_factor_F90(vec3 f0, float f90, float product)
{
	return f0+(vec3(f90)-f0)*pow(1.0-product,5.0);
}

vec3 fresnel_factor(vec3 f0, float product)
{
	return mix(f0, vec3(1.0), pow(1.01 - product, 5.0));
}

float D_GGX(float roughness, float NdH)
{
	float m = roughness * roughness;
	float m2 = m*m;
	float d = (NdH * m2 - NdH) * NdH + 1.0;
	return m2 / (Pi*d*d);
}

float G_schlick(float roughness, float NdV, float NdL)
{
	float r=(roughness+1.0)/2.0;
	float k=r*r*0.5;
	float V = NdV * (1.0 - k) + k;
	float L = NdL * (1.0 - k) + k;
	return (V*L);
}

vec3 CookTorrance(float NdL, float NdV, float NdH, vec3 F, float roughness)
{
	float D = D_GGX(roughness, NdH);
	float G = G_schlick(roughness, NdV, NdL);
	return (D*F*G) / mix(1.0-(roughness*0.9),1.0,4*NdL*NdV);
} 

vec3 ComputeSunLight(vec3 N, vec3 vdir, vec3 ldir, float perturb)
{
	//vec3 diffuse=vec3(0.0,0.0,0.0);
	
	// atmosphere ////////////
	vec3 Wpos=(vpos.xyz*length_unit)-earth_center.xyz;
	vec3 sunColor = GetSunIrradiance(Wpos, sundirW);
	//////////////////////////

	// SHADOW MAP CODE
	float occ=1.0;
	float dOfs = cOfs*0.5;
	vec3 shadowcoords;
	vec4	XYproj;	
	shadowOcc=1.0;
	vec3 projcoords;
	vec4 reprojPos;
	
	vec4 perturbedpos=eyepos+(vec4(N,0.0)*perturb*400.0);
	
	XYproj.x = dot(perturbedpos,LTM0e);
	XYproj.y = dot(perturbedpos,LTM1e);
	XYproj.z = dot(perturbedpos,LTM2e);
	XYproj.w = dot(perturbedpos,LTM3e);

	projcoords.xy=XYproj.xy;
	/*projcoords.xy+=perturb;
	projcoords.xy=clamp(projcoords.xy,0.0,1.0);*/
	projcoords.z=XYproj.z-0.0025;
			
	if( (clamp(projcoords.x,0.0,1.0)==projcoords.x)&&(clamp(projcoords.y,0.0,1.0)==projcoords.y) )
	{	
		occ=0.0;
		shadowcoords.z=projcoords.z;

		shadowcoords.xy=projcoords.xy+vec2(-dOfs,dOfs);
		occ+=shadow2D(shadowmapGlobal,shadowcoords).r;

		shadowcoords.xy=projcoords.xy+vec2(dOfs,dOfs);
		occ+=shadow2D(shadowmapGlobal,shadowcoords).r;

		shadowcoords.xy=projcoords.xy+vec2(dOfs,-dOfs);
		occ+=shadow2D(shadowmapGlobal,shadowcoords).r;

		shadowcoords.xy=projcoords.xy+vec2(-dOfs,-dOfs);
		occ+=shadow2D(shadowmapGlobal,shadowcoords).r;

		occ *= 0.25;
		
		float lightrange16=lightrange8*3.0;
		float lrangeMin=lightrange16-2000.0;
		occ=mix(occ,1.0,( clamp( (-eyepos.z-lrangeMin)/(lightrange16-lrangeMin),0.0,1.0) ));
		shadowOcc = occ;
			
		if(occ>0.0)
		{
			if( -eyepos.z/lightrange <= 1.0 )
			{
				// COMPUTE LIGHT TEXTURE PROJECTION + ATTENUATION
				XYproj.x = dot(perturbedpos,LTM0);
				XYproj.y = dot(perturbedpos,LTM1);
				XYproj.z = dot(perturbedpos,LTM2);
				XYproj.w = dot(perturbedpos,LTM3);

				projcoords.xy=XYproj.xy;
				/*projcoords.xy+=perturb;
				projcoords.xy=clamp(projcoords.xy,0.0,1.0);*/
				projcoords.z=XYproj.z-0.00005;
				///////////////////////////////////
				
				dOfs = cOfs*0.5;
				occ=0.0;

				shadowcoords.z=projcoords.z;

				shadowcoords.xy=projcoords.xy+vec2(-dOfs,dOfs);
				occ+=shadow2D(shadowmap,shadowcoords).r;

				shadowcoords.xy=projcoords.xy+vec2(dOfs,dOfs);
				occ+=shadow2D(shadowmap,shadowcoords).r;

				shadowcoords.xy=projcoords.xy+vec2(dOfs,-dOfs);
				occ+=shadow2D(shadowmap,shadowcoords).r;

				shadowcoords.xy=projcoords.xy+vec2(-dOfs,-dOfs);
				occ+=shadow2D(shadowmap,shadowcoords).r;
				
				occ *= 0.25;
				shadowOcc*=occ;
			}
			else
			{	
				if( -eyepos.z/lightrange2 <= 1.0 )
				{
					// COMPUTE LIGHT TEXTURE PROJECTION + ATTENUATION
					reprojPos=reprojTM2*perturbedpos;
					XYproj.x = dot(reprojPos,LTM0b);
					XYproj.y = dot(reprojPos,LTM1b);
					XYproj.z = dot(reprojPos,LTM2b);
					XYproj.w = dot(reprojPos,LTM3b);

					projcoords.xy=XYproj.xy;
					/*projcoords.xy+=perturb;
					projcoords.xy=clamp(projcoords.xy,0.0,1.0);*/
					projcoords.z=XYproj.z-0.0004;
					///////////////////////////////////

					dOfs = cOfs*0.5;
					occ=0.0;

					shadowcoords.z=projcoords.z;

					shadowcoords.xy=projcoords.xy+vec2(-dOfs,dOfs);
					occ+=shadow2D(shadowmap2,shadowcoords).r;

					shadowcoords.xy=projcoords.xy+vec2(dOfs,dOfs);
					occ+=shadow2D(shadowmap2,shadowcoords).r;

					shadowcoords.xy=projcoords.xy+vec2(dOfs,-dOfs);
					occ+=shadow2D(shadowmap2,shadowcoords).r;

					shadowcoords.xy=projcoords.xy+vec2(-dOfs,-dOfs);
					occ+=shadow2D(shadowmap2,shadowcoords).r;
					
					occ *= 0.25;
					shadowOcc*=occ;
					/*float lrangeMin=lightrange2-200.0;
					shadowOcc=mix(shadowOcc,1.0,( clamp( (-eyepos.z-lrangeMin)/(lightrange2-lrangeMin),0.0,1.0) ));*/
				}
				else
				{
					if( -eyepos.z/lightrange4 <= 1.0 )
					{
						// COMPUTE LIGHT TEXTURE PROJECTION + ATTENUATION
						reprojPos=reprojTM4*perturbedpos;
						XYproj.x = dot(reprojPos,LTM0c);
						XYproj.y = dot(reprojPos,LTM1c);
						XYproj.z = dot(reprojPos,LTM2c);
						XYproj.w = dot(reprojPos,LTM3c);

						projcoords.xy=XYproj.xy;
						/*projcoords.xy+=perturb;
						projcoords.xy=clamp(projcoords.xy,0.0,1.0);*/
						projcoords.z=XYproj.z-0.0006;
						///////////////////////////////////

						dOfs = cOfs*0.5;
						occ=0.0;

						shadowcoords.z=projcoords.z;

						shadowcoords.xy=projcoords.xy+vec2(-dOfs,dOfs);
						occ+=shadow2D(shadowmap4,shadowcoords).r;

						shadowcoords.xy=projcoords.xy+vec2(dOfs,dOfs);
						occ+=shadow2D(shadowmap4,shadowcoords).r;

						shadowcoords.xy=projcoords.xy+vec2(dOfs,-dOfs);
						occ+=shadow2D(shadowmap4,shadowcoords).r;

						shadowcoords.xy=projcoords.xy+vec2(-dOfs,-dOfs);
						occ+=shadow2D(shadowmap4,shadowcoords).r;
					
						occ *= 0.25;
						
						float lrangeMin=lightrange4-300.0;
						occ=mix(occ,1.0,( clamp( (-eyepos.z-lrangeMin)/(lightrange4-lrangeMin),0.0,1.0) ));
						shadowOcc*=occ;
					}
					/*else
					{
						if( -eyepos.z/lightrange8 <= 1.0 )
						{
							// COMPUTE LIGHT TEXTURE PROJECTION + ATTENUATION
							reprojPos=reprojTM8*eyepos;
							XYproj.x = dot(reprojPos,LTM0d);
							XYproj.y = dot(reprojPos,LTM1d);
							XYproj.z = dot(reprojPos,LTM2d);
							XYproj.w = dot(reprojPos,LTM3d);

							projcoords.xy=XYproj.xy;
							projcoords.z=XYproj.z-0.002;
							///////////////////////////////////

							float dOfs = cOfs*0.5;
							shadowOcc=0.0;

							vec3 shadowcoords;
							shadowcoords.z=projcoords.z;

							shadowcoords.xy=projcoords.xy+vec2(-dOfs,dOfs);
							shadowOcc+=shadow2D(shadowmap8,shadowcoords).r;

							shadowcoords.xy=projcoords.xy+vec2(dOfs,dOfs);
							shadowOcc+=shadow2D(shadowmap8,shadowcoords).r;

							shadowcoords.xy=projcoords.xy+vec2(dOfs,-dOfs);
							shadowOcc+=shadow2D(shadowmap8,shadowcoords).r;

							shadowcoords.xy=projcoords.xy+vec2(-dOfs,-dOfs);
							shadowOcc+=shadow2D(shadowmap8,shadowcoords).r;
					
							shadowOcc *= 0.25;
								
							float lrangeMin=lightrange8-1000.0;
							shadowOcc=mix(shadowOcc,1.0,( clamp( (-eyepos.z-lrangeMin)/(lightrange8-lrangeMin),0.0,1.0) ));
						}
					}*/
				}
			}
		}
	}
	////////////////////////////////////////
	
	vec3 diffuse = vec3(0.0,0.0,0.0);
	vec3 specular= vec3(0.0,0.0,0.0);
		
	/*float specular=0.0;
		
	if(shadowOcc>0.0)
	{
		float S=fresnel.y*normalColor.a;
		if(S>0.0)	// specular reflectance (fresnel)
		{
			float REFL=fresnel.x;
			vec3 H = normalize(ldir+vdir);
			float NdotH = (dot(H,N.xyz));
			float EdotH = dot(vdir,H);
			float NdotE = dot(N.xyz,vdir);
			float NdotL = dot(ldir,N.xyz);
			float F=min(REFL,0.4)+(1.0-REFL)*pow((1.0-EdotH),5.0);//float F=0.1+0.9*pow((1.0-EdotH),5.0);
			specular=max((0.0397436*S+0.0856832)*(F*pow(NdotH,S)/max(NdotL,NdotE)),0.0);
		}					
	}*/
	
	vec3 H = normalize(ldir+vdir);
	float NdotL = clamp(dot(ldir,N.xyz),0.0,1.0);

	if(shadowOcc>0.0)
	{
		vec3 REFL=vec3(fresnel.x);
		float rough=sqrt(fresnel.y*normalColor.a);
		
		// compute all vectors
		float NdotH = (dot(H,N.xyz));
		float EdotH = clamp(dot(vdir,H),0.0,1.0);
		float NdotE = clamp(dot(N.xyz,vdir),0.0,1.0);
		
		// fresnel
		vec3 specfresnel=fresnel_factor(REFL, EdotH)*REFL;
		
		// diffuse
		diffuse = ((vec3(1.0) - specfresnel) * phong_diffuse() * NdotL);
	
		// specular
		specular = CookTorrance(NdotL,NdotE, NdotH, specfresnel, rough) * NdotL;
	}

	//diffuse = vec3(transparency*clamp(dot(N,ldir),0.0,1.0)/Pi*0.9);
	//	return (diffuse+specular)*lightcolor.rgb*shadowOcc;
	
	return (diffuseColor.rgb*diffuse*transparency + specular)*lightcolor.rgb*sunColor.rgb*shadowOcc;
}

void main()
{
	vec3 background;
	vec3 ambient;
	
	normalColor=texture2D(bmp,texcoord1.st);
	vec3 normal=normalize((normalColor.xyz*2.0)-1.0);
	vec4 normalColor1=texture2D(bmp1,texcoord2.st);
	vec3 normal1=(normalColor1.xyz*2.0)-1.0;
	
	vec4 normalColor2=texture2D(bmp2,texcoord3.st);
	vec3 normal3=(normalColor2.xyz*2.0)-1.0;
	
	vec3 normal2=normal;
	normal=(normal2+normal1)*0.5;
	normal=(normal3 + normal)*0.5;
	normal=normalize(normal);
	
	vec2 perturbation=normal.xy*density.x;
	vec2 UV=(pos.xy/pos.w)*0.5+0.5;
	
	vec2 UVred=clamp(UV+perturbation*0.8,0.0,1.0);
	vec2 UVgreen=clamp(UV+perturbation,0.0,1.0);
	vec2 UVblue=clamp(UV+perturbation*1.2,0.0,1.0);
	
	texColor=texture2D(tex,texcoord.st+perturbation*0.5);
	texColor.rgb=pow(texColor.rgb,vec3(2.2));
	
	float depth=texture2D(depthBG,clamp(UV+perturbation,0.0,1.0)).r;
			
	vec3 N;
	vec3 vdir;
	
	float dist=abs(depth-eyepos.z);
	float alphaT=clamp(dist*(1.0-foamW),0.0,1.0);
	alphaT=mix(texColor.a,1.0,alphaT)*mix(normalColor.a*normalColor1.a*normalColor2.a,1.0,slope);
	
	N=TBN*normal;
	N=normalize(N);
	//float E=fresnel.y*0.00390625*alphaT;
	vdir=normalize(viewDir);		
	vec3 lit=ComputeSunLight(N, vdir, lightDir, 0.1);
	
	float waterDensity=(clamp(pow(log(dist*density.y+1.0)*0.5,0.5),0.0,1.0));
	background=mix(vec3(texture2D(bg,UVred).r,texture2D(bg,UVgreen).g,texture2D(bg,UVblue).b),refrColor*shadowOcc*0.5+refrColor*ambientColor.rgb*0.5,waterDensity);

	vec3 reflection = reflect(vdir,N);
	reflection= ((ambientPos-vpos.xyz)*invAmbientRange) + reflection;
	
	/*
	float glossLod=(1.0-E)*cubeLod2;	
	vec4 specularAmb = RGBMDecode(textureCubeLod(ambientCube,reflection.xyz,glossLod));
	vec4 diffuseAmb=RGBMDecode(textureCubeLod(ambientCubeDiffuse,N.xyz,cubeLod));	
	diffuseAmb = (diffuseAmb+vec4(ambientScatter))/vec4(1.0+ambientScatter);
	
	vec3 REFL=vec3(fresnel.x);
	vec3 F=min(REFL,vec3(0.4))+(vec3(1.0)-REFL)*pow((1.0-abs(dot(vdir,N.xyz))),5.0);
			
	ambient=ambientColor.rgb*((1.0-alphaT)*texColor.rgb*diffuseColor.rgb*diffuseAmb.rgb+specularAmb.rgb*F);
	*/
	
	/////////////////////////////////////////////////////////////
	float NdotE = clamp(dot(N.xyz,vdir),0.0,1.0);
	
	vec3 REFL=vec3(fresnel.x);
	float rough=sqrt(fresnel.y*normalColor.a);

	// IBL diffuse
	vec4 IBLdiffuse = RGBMDecode(textureCubeLod(ambientCubeDiffuse,-N.xyz,cubeLod));
	IBLdiffuse = (IBLdiffuse+vec4(ambientScatter))/vec4(1.0+ambientScatter);
	vec3 diffuse =  IBLdiffuse.xyz * phong_diffuse() * texColor.rgb*diffuseColor.rgb;
	
	// IBL specular
	float glossLod = rough*cubeLod2;
	
	vec4 IBLspecular = RGBMDecode(textureCubeLod(ambientCube,reflection.xyz,glossLod));
	vec2 brdf = texture2D(brdfLUT, vec2(NdotE, rough)).xy;
	vec3 IBL=REFL*brdf.x+brdf.y;
	vec3 specular = IBL*IBLspecular.xyz*REFL;

	ambient=ambientColor.rgb*((1.0-alphaT)*diffuse.rgb+specular.rgb);
	litColor += lit*alphaT+(1.0-alphaT)*texColor.rgb*diffuseColor.rgb*lightcolor.rgb*0.5*clamp(dot(N,lightDir),0.0,1.0)*shadowOcc;
		
	/////////////////////////////////////////////////////////////
	
	vec3 finalColor= (litColor.rgb+ambient.rgb);
	finalColor=mix(finalColor,background,clamp(alphaT*(1.0-alphalevel),0.0,1.0));

	finalColor=finalColor*Fex+Lin;
	gl_FragColor.rgb=max(finalColor,0.0);
	gl_FragColor.a=clamp(dist*0.05,0.0,1.0);
}
